
The use of **security intelligence** is a typical feature available in today's NGFWs, and it works by blocking traffic to or from IP addresses that have a known bad reputation.

 This traffic filtering takes place **before any other policy-based inspection**, analysis, or traffic handling.

The **security intelligence feed** is regularly updated, using it ensures that the system has up-to-date information to filter network traffic with.

For example, the **Cisco Talos Intelligence Group** is one of the threat intelligence leaders in the market.

Security devices regularly **update SI feed** and can create policies based on this feed (block all connection attempts to IP addresses denied in SI feed).
![[Pasted image 20250304162336.png]]

======

**Quiz** 

Which statement correctly describes the difference between security intelligence and typical firewall ACLs in preventing malicious traffic?

- Security intelligence uses a dictionary list of keywords, which, if detected in the data payload, will trigger a security event.
    
- Using intelligence feeds that provide IP addresses with known bad reputations, malicious activity is blocked before any other policy-based inspection, analysis, or traffic handling is performed. (Correct)
    
- ACLs provide a more granular ability to control known bad IP addresses that have a poor reputation. Security intelligence feeds are broader in scope.
    
- Security intelligence feeds can be used to detect security issues in improperly configured ACLs.
    
- ACLs provide superior reflexive ACL entries, based on the known IP address that has a poor reputation, which will automatically be installed in the inspection engine of next generation firewalls.

**Quiz Question**:

**Question**: In the battle against evolving cyber threats, how does security intelligence in a next-generation firewall, such as Cisco's Secure Firewall, enhance your network's defense strategy?

- A) By continuously analyzing all network traffic without any preemptive measures.
- B) By dynamically blocking traffic from IP addresses identified in up-to-date threat intelligence feeds.
- C) By manually updating firewall rules to block known threats after detection.
- D) By allowing all traffic and relying on reactive measures post-incident.

**Correct Answer**: B) By dynamically blocking traffic from IP addresses identified in up-to-date threat intelligence feeds.

**Explanation**: Security intelligence uses real-time threat feeds to automatically block traffic from IPs associated with threats, enabling the firewall to prevent attacks efficiently without needing manual updates or exhaustive inspections.


